/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.ModPack;
import net.ftb.data.TexturePack;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.gui.panes.TexturepackPane;
import net.ftb.locale.I18N;
import net.ftb.util.SwingUtils;

public class TexturePackFilterDialog
extends JDialog {
    private JLabel compatiblePackLbl;
    private JComboBox compatiblePack;
    private JLabel resolutionLbl;
    private JComboBox resolution;
    private JButton apply;
    private JButton cancel;
    private JButton search;
    private TexturepackPane instance;

    public TexturePackFilterDialog(final TexturepackPane instance) {
        super((Frame)LaunchFrame.getInstance(), true);
        this.instance = instance;
        this.setupGui();
        this.getRootPane().setDefaultButton(this.apply);
        int textures = TexturePack.getTexturePackArray().size();
        ArrayList<String> res = new ArrayList<String>();
        res.add("All");
        for (int i = 0; i < textures; ++i) {
            if (res.contains(TexturePack.getTexturePack(i).getResolution())) continue;
            res.add(TexturePack.getTexturePack(i).getResolution());
        }
        ArrayList<String> comp = new ArrayList<String>();
        comp.add("All");
        for (int i = 0; i < textures; ++i) {
            List<String> s = TexturePack.getTexturePack(i).getCompatible();
            for (String value : s) {
                if (comp.contains(ModPack.getPack(value.trim()).getName())) continue;
                comp.add(ModPack.getPack(value.trim()).getName());
            }
        }
        this.compatiblePack.setModel(new DefaultComboBoxModel<String>(comp.toArray(new String[comp.size()])));
        this.resolution.setModel(new DefaultComboBoxModel<String>(res.toArray(new String[res.size()])));
        this.compatiblePack.setSelectedItem(TexturepackPane.compatible);
        this.resolution.setSelectedItem(TexturepackPane.resolution);
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TexturepackPane.compatible = (String)TexturePackFilterDialog.this.compatiblePack.getSelectedItem();
                TexturepackPane.resolution = (String)TexturePackFilterDialog.this.resolution.getSelectedItem();
                1 v0 = this;
                v0.instance.updateFilter();
                TexturePackFilterDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TexturePackFilterDialog.this.setVisible(false);
            }
        });
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchDialog sd = new SearchDialog(instance);
                sd.setVisible(true);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("FILTER_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.compatiblePackLbl = new JLabel(I18N.getLocaleString("FILTER_COMPERTIBLEPACK"));
        this.resolutionLbl = new JLabel(I18N.getLocaleString("FILTER_RESULUTION"));
        this.resolution = new JComboBox();
        this.compatiblePack = new JComboBox();
        this.apply = new JButton(I18N.getLocaleString("FILTER_APPLY"));
        this.cancel = new JButton(I18N.getLocaleString("MAIN_CANCEL"));
        this.search = new JButton(I18N.getLocaleString("FILTER_TEXSEARCH"));
        this.resolution.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.compatiblePack.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        panel.add(this.compatiblePackLbl);
        panel.add(this.resolutionLbl);
        panel.add(this.compatiblePack);
        panel.add(this.resolution);
        panel.add(this.apply);
        panel.add(this.cancel);
        panel.add(this.search);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.compatiblePackLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.resolutionLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = Spring.max(Spring.width(this.compatiblePackLbl), Spring.width(this.resolutionLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)this.compatiblePack, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.resolution, hSpring, "West", (Component)panel);
        columnWidth = Spring.max(Spring.width(this.compatiblePack), Spring.width(this.resolution));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.compatiblePack, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.resolution, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.search, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.search, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.cancel, 5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.cancel, -10, "East", (Component)panel);
        layout.putConstraint("West", (Component)this.apply, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.apply, -10, "East", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.compatiblePackLbl, 0, "Baseline", (Component)this.compatiblePack);
        layout.putConstraint("North", (Component)this.compatiblePack, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.compatiblePackLbl), Spring.height(this.compatiblePack));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.resolutionLbl, 0, "Baseline", (Component)this.resolution);
        layout.putConstraint("North", (Component)this.resolution, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.resolutionLbl), Spring.height(this.resolution));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.search, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.cancel, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.search), Spring.height(this.cancel));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("North", (Component)this.apply, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.apply), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

